---
title: 'The M3P2 curriculum'
visible: false
---

#### The M3P2 curriculum

**At the center of the M3P2 curriculum is yourself**. First you need to *better understand and master the external physical world* : the world of natural phenomena, and the world of technologies created by humans. In parallel you must *better know the functioning of the human being* you are : his physical body and his psychic being. Finally, you have to *master and balance the interactions between the individual being that you are and this external world* of matter, interactions and relationships. These three requirements are addressed by M3P2 in *eight major themes, tackled from a scientific and technical point of view*. Partner universities validate the educational content in their area of expertise. The eight major themes fall into the three requirements according to the scheme:

**An outside world to understand and master:**
* Perceptions of an external world: towards the *experimental sciences*.
* Internal logic and mental representations: towards our *ability to model the world*.
* An impacting technological environment: towards our ability to *understand and master technologies*.

**An internal being to know**
* A being in search of meaning : towards what science reveals about our *origins and fundamentals*.
* An internal physical body: towards the knowledge of our body *and its needs*.
* An inner psychic being: towards the knowledge of our *thinking being and cognitive biases*.

**A being interacting with the external world** (physical, social and technological)
* A relational being, which *perceives other beings* and *is perceived through others*.
* A relational being, who understands, *communicates and acts* with others, *in a team*, *in society*, *internationally*.
* A being whose *actions* have a *societal, ethical and environmental impact*.

#### 4 levels of increasing mastery

Conducted essentially, and validated by university professors, the teaching contents in M3P2 are first conceived for the students of the partner institutes (like course support, course complement, or inverted course, or to review useful prerequisites at the master / engineer level). You will therefore find courses **covering an entire undergraduate level** (university or engineering school). 

To remedy the great diversity of origin and training of incoming students (national or university exchange) in our engineering schools and universities, each course is derived at **a pre-undergraduate level**. Without covering the programs of national high schools (M3P2 is not a site of preparation for the various national baccalaureates), this level of essential prerequisites to follow with serenity studies at university corresponds typically to a level of end of secondary studies. In addition to the useful knowledge, the settings of the self-assessment that will be implemented (objective 2022) will reassure you on the level of knowledge mastery and of competence acquired. 

Finally, in order to participate in the global effort of education and training in the scientific mind and method, each course starts at **a basic level, citizen**. 

!!!! M3P2 does not wish and can not in any way shool and highschool education: the accompaniment of young people by teachers, this human presence who guides young people in their learning is indispensable and irreplaceable. Also this basic level corresponds noticeably to a level where the school ceases to be compulsory in the various countries : it is the knowledge that every human should have in each theme to fully live his life as a citizen.

There is no direct link between a level and a specific academic year in high school, or a specific year of undergraduate university. *The levels are set by the pedagogical teams*, which take as objectives both the knowledge and skills to acquire before a master's degree, and basic knowledge on the same theme that must be understood by each citizen.

#### The pedagogical pathway

An **pedagogical pathway** is a *course on a specific subject in the four levels*of increasing complexity and mastery of the subject. A **pedagogical stage** is the *pedagogical content of a pathway at a corresponding level*. 

This pedagogical pathway is *collaboratively built by an international team* from the stage of the highest level  to the basic lowest level, and ensures *consistency and continuity between the stages*. 

This pedagogical pathway is traveled by the learner from the basic level to the highest level. 

To build the various intermediate steps, the teaching team answered the following questions:
- If the learner must forget everything about this level N, what should he remember at the lower level.
- what is the added value, in terms of mastering more complex situations, of the higher level.

**The four stages** are called in reference to the presumed difficulty of an equivalent ramble : "*plain*", "*hills*", "*foothills*" and " *Mountain*". This denomination was chosen because it refers more to the ability of the user to be comfortable and therefore appreciate a course that reaches the chosen level, rather than using a qualification of the user himself in terms of "novice" for the lowest level, up to "expert" for the highest.

#### The pedagogical circuit

The concept of circuit refers to a ramble that comes back to itself (the word "circuit" comes from the Latin "circuitus", to "circuire", which means "to surround"). A  **pedagogical circuit** therefore consists of *a stage to acquire and master in each of the pedagogical pathways* of the M3P2 curriculum, *in each of the eight major themes*.

#### The pedagogical project

In the end, when the self-evaluation "will be implemented in M3P2, you will be able to define your **pedagogical project**. Your" pedagogical project "is the *pedagogical circuit* that you would like to be acquire and master at a specific *date*. You will be able to define your own project by setting a level for each pedagogical pathway, or each set of pedagogical pathways. (M3P2 will automatically help you to build it : for example, choosing a "conterforts" level in such a pathway in physics probably requires a equivalent level in an pedagogical pathway adapted in mathematics). You will be able to build your pedagogical project by adopting a pedagogical circuit proposed by a partner institute, by attributing to it a date of realization.

#### The partner institutes

The **partner institutes** can offer *one or more educational circuits*. this may be for example:
* a *pre-requisite* program for a quieter first year in the institute that lays down the circuit.
* a *program for an admission* exam.
* the *program of a specific year or semester* undergraduate in a specialty offered by the institute.

In the end, M3P2 knowing your project (so the circuit that you wish to eventually control and the date you want to be ready), the self-assessment of M3P2 can guide you (or not, according to your wishes) to optimize your preparation and the realization of your pedagogical project.
